#version 330
#extension GL_EXT_gpu_shader4 : enable
//Warpy squiggly thingyMod01.fsh by SnoopethDuckDuck
//https://www.shadertoy.com/view/ft2XDR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// The MIT License
// Copyright © 2013 Inigo Quilez
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


// Simplex Noise (http://en.wikipedia.org/wiki/Simplex_noise), a type of gradient noise
// that uses N+1 vertices for random gradient interpolation instead of 2^N as in regular
// latice based Gradient Noise.


// Value    Noise 2D, Derivatives: https://www.shadertoy.com/view/4dXBRH
// Gradient Noise 2D, Derivatives: https://www.shadertoy.com/view/XdXBRH
// Value    Noise 3D, Derivatives: https://www.shadertoy.com/view/XsXfRH
// Gradient Noise 3D, Derivatives: https://www.shadertoy.com/view/4dffRH
// Value    Noise 2D             : https://www.shadertoy.com/view/lsf3WH
// Value    Noise 3D             : https://www.shadertoy.com/view/4sfGzS
// Gradient Noise 2D             : https://www.shadertoy.com/view/XdXGW8
// Gradient Noise 3D             : https://www.shadertoy.com/view/Xsl3Dl
// Simplex  Noise 2D             : https://www.shadertoy.com/view/Msf3WH
// Wave     Noise 2D             : https://www.shadertoy.com/view/tldSRj
const float tau = 2. * 3.14159;

vec2 hash( vec2 p ) // replace this by something better
{
	p = vec2( dot(p,vec2(127.1,311.7)), dot(p,vec2(269.5,183.3)) );
	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float noise( in vec2 p )
{
     float t = 0.01* log(iTime + 10.);
     float K1 = 0.366025404; // (sqrt(3)-1)/2;
     float K2 = 0.211324865; // (3-sqrt(3))/6;

	vec2  i = floor( p + (p.x+p.y)*K1 );
    vec2  a = p - i + (i.x+i.y)*K2;
    float m = step(a.y,a.x); 
    vec2  o = vec2(m,1.0-m);
    vec2  b = a - o + K2;
	vec2  c = a - 1.0 + 2.0*K2;
    vec3  h = max( 0.5-vec3(dot(a,a), dot(b,b), dot(c,c) ), 0.0 );
	vec3  n = h*h*h*h*vec3( dot(a,hash(i+0.0)), dot(b,hash(i+o)), dot(c,hash(i+1.0)));
    return dot( t + n, vec3(70.0) );
}

vec4 colorMap(vec3 a, vec3 b, vec3 c, vec3 d, float t) {
vec3 col = a + b * vec3(cos(tau * (c.r * t + d.r)),
                        cos(tau * (c.g * t + d.g)),
                        cos(tau * (c.b * t + d.b)));

return vec4(col.r, col.g, col.b, 1.);
}

// -----------------------------------------------
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    //vec2 p = gl_FragCoord.xy / iResolution.xy;

	//vec2 uv = p*vec2(iResolution.x/iResolution.y,1.0) + iTime*0.05;
	vec2 R = iResolution.xy;
vec2 uv = 2.8 * (gl_FragCoord.xy  -0.5 * R.xy)/R.y;
float screenWarp = 1.0+pow(length(uv), 3. * cos(0.4 * iTime))*0.3;
uv *= screenWarp;
uv += vec2(2. * sin(iTime), 0.4 *iTime);

	float f = 0.0;
		uv = uv * 0.04;
        mat2 m = (1. + 0.005 * noise(uv + 0.5 * vec2(cos(0.5 *iTime),0.5 * sin(0.5*iTime)))) * mat2( 1.6,  1.2, -1.2,  1.6 );
		f  = 0.800*noise( uv ); uv = m*uv;
		f += 0.100*noise( uv ); uv = m*uv;
		f += 0.050*noise( uv ); uv = m*uv;
		f += 0.025*noise( uv ); uv = m*uv;
        
	f += 1.8 * noise(4.8* (1.-uv));//cos(3.14159 * 2. * (1. + cos(0.3 * iTime)) * f * (1.-f));
    
vec3 h = vec3(0.5, 0.5, 0.5);
float t = 0.05 * iTime +1.1;
float b1 = 0.25 * (1. + cos(t));
float b2 = 0.25 * (1. + cos(t + tau / 3.));
float b3 = 0.25 * (1. + cos(t + 2. * tau / 3.));
float k = 0.1 * cos(0.8 * iTime + f);
gl_FragColor = colorMap(h-t, h + t, h, vec3(0.5 + k,0.5,0.5 - k), f);

}
